﻿var se = {
    baseUrl: "",
    currentMatrix: 0,
    variablesMatrix: null,
    answers: null,
    executeSoftPromptValidation: true,
    softPromptCallbacks: null
};

var variableLogicElements = ["div.choice", "select.dropDown", "input.editBox", "div.sliderContentsRow", "div.starRating", "div.errorMessageContainer", "span.leftLabel", "span.rightLabel"];

var getEquationFunction = function (expression, negate) {
    var logic = expression != null ? expression : "true";
    try {
        return new Function("e", "return " + (negate ? "!" : "") + logic);
    } catch (err) {
        return new Function("e", "return true");
    }
}

var expressionEvaluator = {
    initialize: function () {
        this.initializeLogicForClass(".hideif", "hideif", true);
        this.initializeLogicForClass(".displayif", "displayif", false);
        this.initializeLogicForClass("div.variableif", "variableif", true);
        this.initializeMultiVariablesLogic();
    },
    initializeLogicForClass: function (className, logicPrefix, inverseCondition) {
        $(className).each(function () {
            var t = $(this);
            if (t.data(logicPrefix + "-logic-type") == 0) {
                createLogic(t, getVariables(t), getEquationFunction(t.data(logicPrefix + "-logic"), inverseCondition));
            } else {
                createAdvancedLogic(t, getVariables(t), t.data(logicPrefix + "-logic"), inverseCondition, t.data("logic-qid"));
            }
        });
    },
    initializeMultiVariablesLogic: function () {
        $("tr[class*='variableif'], div[class*='variableif']").each(function () {
            var t = $(this);
            var matches = t.attr('class').match(/(?:^|\W)variableif(\w+)(?!\w)/g);

            if (matches && matches.length > 0) {
                for (var i = 0; i != matches.length; i++) {
                    var cond = matches[i].trim();

                    if (cond.indexOf("serverSideSkipped") == -1) {
                        var varLogicIdx = cond.replace('variableif', '');
                        var items = t;

                        if (t.is("tr")) {
                            var columns = t.find("td[data-column-position=" + varLogicIdx + "]");
                            items = $(variableLogicElements.join(","), columns);
                        } else {
                            items = t.find("div[data-column-position=" + varLogicIdx + "]");

                            if (items.length == 0) {
                                items = t;
                            }
                        }

                        if (t.data(cond + "-logic").length > 0) {
                            if (t.data(cond + "-logic-type") == 0) {
                                createLogic(items, getVariables(t, cond), getEquationFunction(t.data(cond + "-logic"), true));
                            } else {
                                createAdvancedLogic(items, getVariables(t, cond), t.data(cond + "-logic"), true, t.data(cond + "-logic-qid"), cond);
                            }
                        }
                    }
                }
            }
        });
    }
}

$(document).ready(function () {
    se.baseUrl = $("#SEURL").val();
    var answers = $("#RespondentAnswers").val();
    se.answers = JSON.parse(answers);
    se.currentMatrix = $("#Matrix").val();

    var variablesMatrixDefinition = $("#VariablesMatrix").val();
    if (variablesMatrixDefinition)
        se.variablesMatrix = JSON.parse(variablesMatrixDefinition);

    expressionEvaluator.initialize();

    initializeSoftPrompt();
    resetNavigationButtonState();
});

function initializeSoftPrompt() {
    $(".softPromptColumn").each(function () {
        var column = $(this);
        updateGridColspan(column, -1);
        var controls = getDepedentControls(column);
        controls.hide();
    });

    var updateAutoCompletes = false;
    $(".softPromptChoice").each(function () {
        if ($(this).is("option"))
            $(this).prop("disabled", true);

        if (!updateAutoCompletes && $(".autoComplete", $(this).closest(".questionContent"))) {
            updateAutoCompletes = true;
        }

        $(this).closest(".gridItem").hide();
    });

    $(".errorMessageSoftPrompt").each(function () {
        var gridItem = $(this).closest("td.gridItem");

        if (gridItem.length > 0) {
            var row = gridItem.parent();
            updateGridRowsClasses(row);
        }
    });

    var hrefLink = "";
    $(".nextButton").on("click", function (event) {
        event.preventDefault();

        // Numeric Ranking client side validation
        if (typeof numericRankingValidation === "function" && !numericRankingValidation()) {
            return;
        }

        $(this).prop("disabled", true);

        hrefLink = $(this).attr("href");

        if (se.executeSoftPromptValidation) {
            var validated = true;

            $(".questionBackground:visible .errorMessage.errorMessageSoftPrompt").each(function () {
                var errorSoftPrompt = $(this);
                var questionContainer = errorSoftPrompt.closest(".questionContainer");
                var variables = errorSoftPrompt.closest(".errorMessageContainer").data("question-variables").split(",");

                if (!questionVariablesHaveAnswer(variables, questionContainer)) {
                    $(".softPromptChoice", questionContainer).each(function () {
                        var choice = $(this);

                        if (choice.hasClass("softPromptColumn")) {
                            updateGridColspan(choice, 1);
                            getDepedentControls(choice).show();
                        }

                        if (choice.is("option"))
                            choice.prop("disabled", false);

                        choice.show();
                        choice.closest(".gridItem").show();

                        if (choice.parent().hasClass("dragDropList")) {
                            $(".dragDropList", choice.closest(".dragDropRanking")).each(function () {
                                SetListInitialDimensions($(this));
                            });
                        }
                    });

                    var questionBackground = errorSoftPrompt.closest(".questionBackground");
                    $(".summaryError", questionBackground).hide();

                    var gridItem = errorSoftPrompt.closest("td.gridItem");

                    if (gridItem.length > 0) {
                        var row = gridItem.parent();
                        row.show();
                        updateGridRowsClasses(row);
                    }

                    errorSoftPrompt.show();

                    validated = false;
                }
            });

            if (updateAutoCompletes && typeof updateAllAutoCompletesData == "function")
                updateAllAutoCompletesData();

            executeSoftPromptCallBack();

            se.executeSoftPromptValidation = false;

            if (!validated) {
                $(this).prop("disabled", false);

                if ($(this).is("a")) {
                    $(this).attr("href", hrefLink);
                }
            } else {
                executeSoftPromptPostBack($(this));

                if ($(this).is("a")) {
                    $(this).removeAttr("href");
                }
            }
        }
        else {
            executeSoftPromptPostBack($(this));

            if ($(this).is("a")) {
                $(this).removeAttr("href");
            }
        }
    });
}

function questionVariablesHaveAnswer(variables, questionContainer) {
    var questionType = questionContainer.attr("data-questiontype");
    var canHaveEmptyVariables = questionType == "imageareaevaluator" || questionType == "cardsort";

    for (var i = 0; i < variables.length; i++) {
        // Do not consider skipped variables.
        if (IsVariableSkipped(variables[i]))
            continue;
        var answer = GetRespondentAnswer(variables[i]);
        var variableHasAnswer = answer != null && answer.length > 0 && !isEmptyAnswer(answer);
        // If we cant have empty variables, and a variable is UNANSWERED, return false.
        if (!canHaveEmptyVariables && !variableHasAnswer)
            return false;
        // If we can have empty variables, and a variable is ANSWERED, return true.
        if (canHaveEmptyVariables && variableHasAnswer)
            return true;
    }
    // If we did not find any UNANSWERED variable return true,
    // unless we can have empty variables, return false.
    return !canHaveEmptyVariables;
}

function executeSoftPromptPostBack(control) {
    if (control.attr("href")) // mobile unnamed link usage
        eval(control.attr("href"));
    else if (!control.is("a"))
        __doPostBack(control.attr("name"), '');
}

function updateMobileSoftPromptDisplay(context, isCallback) {
    $(".ui-controlgroup-controls", context).each(function () {
        var controlGroup = $(this);
        var uiControl = $(":first-child", controlGroup).hasClass("ui-checkbox") ? ".ui-checkbox" : ".ui-radio";

        $(uiControl + " label", controlGroup).removeClass("ui-first-child").removeClass("ui-last-child");

        var includeSoftPrompt = $(uiControl + " input.softPromptChoice", controlGroup).is(":visible");
        var controls = $(uiControl + " input" + (includeSoftPrompt ? "" : ":not(.softPromptChoice)"), controlGroup);
        if (controls.length > 0) {
            $(controls[0]).siblings("label").addClass("ui-first-child");
            $(controls[controls.length - 1]).siblings("label").addClass("ui-last-child");
        }
    });

    if (!isCallback)
        registerSoftPromptCallBack(function () {
            updateMobileSoftPromptDisplay(context, true);
        });
}

function registerSoftPromptCallBack(callBack) {
    if (se.softPromptCallbacks == null) se.softPromptCallbacks = new Array();
    se.softPromptCallbacks.push(callBack);
}

function executeSoftPromptCallBack() {
    if (se.softPromptCallbacks != null) {
        for (var i = 0; i < se.softPromptCallbacks.length; i++)
            se.softPromptCallbacks[i]();
    }
}

function resetSoftPrompt() {
    se.executeSoftPromptValidation = true;
    $(".questionBackground:visible .errorMessage.errorMessageSoftPrompt").hide();
    $(".gridErrorRowHidden").hide();
}

function getVariables(elem, cond) {
    var item = (cond !== undefined && cond.length > 0) ? cond + "-" : cond;

    var data = elem.data(item + "logic-variables");

    if (data === undefined) {
        data = elem.data("logic-variables");
    }

    if (data != undefined)
        return data.split(",");
    else
        return "";
}

function getDepedentControls(control) {
    if (control.is(".gridColumnLogic")) {
        var table = control.closest(".gridLogic").next(".grid");

        // for hybrid grid multiple columns
        var colIndex = "[data-column-position=" + control.data("column-position") + "]";
        var columnSelector = colIndex;

        if (control.data("choice-position") >= 0) {
            columnSelector = columnSelector + "[data-choice-position=" + control.data("choice-position") + "]";
        }

        control = $("tbody .gridColumnHeader" + columnSelector + ", tbody .gridItem" + columnSelector + ", tbody th" + columnSelector + ", tfoot tr.summary td" + columnSelector + ", tfoot tr.summaryError td" + columnSelector, table);

        // when hiding a column, we check for each cell, its row, if the row use "use choice texts" options and is empty, we hide this one. This is to avoid having empty text rows.
        $.each(control.filter("th:not(.gridColumnHeader)"), function () {
            var row = $(this).parent();
            if (row.hasClass("gridRowUseChoiceTexts")) {
                if ($("th:visible:not(:empty):not(" + colIndex + ")", row).length == 0) {
                    control = control.add(row);
                }
            }
        });


    }
    else if (control.is("th") && control.data("row-position") >= 0) {
        var table = control.closest("table.grid");
        var colIndex = control.index() + 1;
        control = $("th:nth-child(" + colIndex + "), td:nth-child(" + colIndex + ")", table);
    }
    else if (control.is("td")) {
        control = $("td", control.parent());
    }
    else if (!control.is("div, tr, li")) {
        //Get error cells associated to variable cell
        $.each(control, function () {
            var firstCellInput = $(this).closest("td.gridItem").find(":input").first();

            if (firstCellInput && firstCellInput.length > 0) {
                var variableName = firstCellInput.attr("name");

                if (variableName) {
                    variableName = variableName.replace(new RegExp("_" + se.currentMatrix + "$"), "");

                    var cellError = $(".errorMessageContainer[data-question-variables='" + variableName + "']");

                    if (cellError && cellError.length > 0)
                        control = control.add(cellError);
                }
            }
        });
    }

    return control;
}

function updateGridColspan(column, increment) {
    var tableBody = column.closest("tbody");
    var tableGroupHeader = $("tr:first", tableBody);
    if (!tableGroupHeader.hasClass("gridRowUseChoiceTexts")) {
        var header = $("th.gridColumnHeader[data-column-position=" + column.data("column-position") + "]", tableGroupHeader);
        header.attr("colspan", $("th:visible[data-column-position=" + column.data("column-position") + "]", $("tr.gridRowUseChoiceTexts", tableBody)).length)
    }
}

function createLogic(control, variables, equationFunction) {
    var logicEvaluator = new LogicEvaluator(equationFunction);

    $.each(variables, function (index, value) {
        getVariableSelector(value).on("change", function () {
            var result = logicEvaluator.Eval();
            ChangeControlsStates(control, $(this), result, false);
        });
    });

    ChangeControlsStates(control, null, logicEvaluator.Eval(), false);
}

// Wrap the option in <span> if it should be hidden
function wrapInSpan(elements) {
    elements.filter('option:not(:parent span)').wrap('<span>');
}

function createAdvancedLogic(control, variables, equationFunction, isHideIf, questionId, item) {
    $.each(variables, function (index, value) {
        getVariableSelector(value).on("change", function () {
            evaluateServerSideEquation(questionId, control, $(this), variables, equationFunction, isHideIf);
        });
    });

    var dependentControls = getDepedentControls(control);

    if (control.hasClass("serverSideSkipped")) {
        wrapInSpan(dependentControls);
        dependentControls.hide().prop("disabled", true);
    }
    else if (item) {
        var parent = $.mobile ? control.closest("div[data-row-position]") : control.closest("tr");

        if (parent.hasClass("serverSideSkipped" + item)) {
            wrapInSpan(dependentControls);
            dependentControls.hide();
        }
    }

    updateGridRowsClasses(control);
}

function getVariableSelector(value) {
    var controls = $(":input[name=" + value + "_" + se.currentMatrix + "]");

    // added to support choice list on text type questions
    $.each(controls, function () {
        var control = $(this);
        var isTextInput = control.is("input:text");
        var isEmailInput = control.is(":input[type=email]");
        var isTextArea = control.is("textarea")

        if (isTextInput || isEmailInput || isTextArea) {
            var choiceList = $(".choiceList", control.parents(".questionContent"));
            if (choiceList.length > 0) {
                controls = controls.add($("input:radio", choiceList));
            }
        }
    });

    // added to suport choice list on numeric ranking type questions
    if (value) {
        controls = controls.add($(":input[data-variable=" + value + "][data-matrix=" + se.currentMatrix + "]"));
    }

    return controls;
}

function ChangeControlsStates(control, trigger, result, useFx) {
    var controls = getDepedentControls(control);

    if (!result && controls.is("option")) {
        wrapInSpan(controls);
    } else if (result && controls.parent().is('span')) {
        // Unwrap the option from the <span> if it should be shown
        controls.each(function () {
            var $this = $(this);
            if ($this.parent().is('span')) {
                $this.unwrap();
            }
        });
    }

    var isCellLogic = controls.is(variableLogicElements.join(","));

    var visible = controls.is(":visible");

    if (visible && result)
        return;

    if (useFx && !$.mobile) {
        if (result) {
            controls.show("fade", 500);
            control.trigger("client-skip-show");
        }
        else
            controls.hide();
    }
    else
        controls.toggle(result);

    controls.toggleClass("clientSideSkipped", !result).prop('disabled', !result);

    if (!result && visible) {
        var containers = isCellLogic ? controls.parent() : controls;

        $("input, textarea", containers).each(function () {
            var $input = $(this);
            if ($input.is(":checkbox") || $input.is(":radio")) {
                $input.attr("checked", false);
            } else {
                $input.val("");
            }

            if (trigger == null || trigger.attr("id") != $input.attr("id")) {
                $input.trigger("change");

                if ($input.hasClass("numericAnswer")) {
                    $input.trigger("blur");
                }
            }
        });

        $("select", containers).each(function () {
            var $select = $(this);
            $select.val($("option:first", $select).val());
            $select.trigger("change");
        });
    }

    triggerQuestionDisplays(control, result);
    updateGridRowsClasses(control);
    resetSoftPrompt();
    if (typeof initializeAutoAdvance !== 'undefined')
        initializeAutoAdvance();
}

function triggerQuestionDisplays(control, result) {
    var questionContainer = control.closest("div.questionContainer");

    if (questionContainer.length == 0) {
        questionContainer = $("div.questionContainer", control);
    }

    var questionType = questionContainer.data("questiontype");

    if (result) {
        if (questionType == "starratinggrid" || questionType == "hybridgrid") {
            $("div.starRating", questionContainer).starRating("refreshLayout");

            $("div.sliderBar", questionContainer).each(function () {
                SetSliderDimensions($(this));
            });
        }
        else if (questionType == "imageareaselector") {
            $(".imageMap .area", questionContainer).removeClass("selectedImageArea");

            if (typeof setImageAreaSelectorAreas === "function") // does not exists on mobile impl.
                setImageAreaSelectorAreas($(".imageMap", questionContainer), false);
        }
        else if (questionType == "dragdropranking") {
            $(".dragDropList", questionContainer).each(function () {
                SetListInitialDimensions($(this));
            });
        }
        else if (questionType == "cardsort" && questionContainer.is(".standard")) {
            initializeCardSorts();
        }
    }

    if (questionType == "timer") {
        refreshTimers();
    } else if (questionType == "autocomplete" && typeof updateAllAutoCompletesData === "function") {
        updateAllAutoCompletesData();
    }
}

function updateGridRowsClasses(control) {
    if ($(control).is("div.choice.hideif, div.choice.displayif")) {
        var td = $(control).closest("td.gridItem");
        var columnPos = td.attr("data-column-position");

        if (columnPos) {
            var table = td.closest("table.grid");
            var choiceColumn = $("tbody tr th.gridColumnHeader[data-column-position='" + columnPos + "']:not([data-choice-position])", table);

            if (choiceColumn.attr("colspan")) {
                var visibleCount = $("tbody tr th.gridColumnHeader[data-column-position='" + columnPos + "'][data-choice-position]:not(.clientSideSkipped)", table).length;
                choiceColumn.attr("colspan", visibleCount);
                $("tr.gridErrorRow td[data-column-position='" + columnPos + "']", table).attr("colspan", visibleCount);

                choiceColumn.toggle(visibleCount > 0);
                $(".errorMessage", table).parents(".gridItem[data-column-position='" + columnPos + "']", table).toggle(visibleCount > 0);
            }
        }
    }
    else if ($(control).is("tr")) {
        var parent = $(control).closest("table.grid");

        var $el = parent.find("tr:not(.clientSideSkipped):not(.serverSideSkipped)");
        $el.removeClass("gridRow").removeClass("gridAlternateRow");

        var rowClass = "gridRow";
        $.each($el, function (index, value) {
            var $row = $(value);
            if (!$row.is(".gridColumnHeader")) {
                if ($row.is(".gridErrorRow")) {
                    $row.addClass(rowClass);
                } else {
                    $row.addClass(rowClass);
                    rowClass = (rowClass == "gridRow") ? "gridAlternateRow" : "gridRow";
                }
            }
        });

        refreshHeaderRepeat(control);
    }
}

function evaluateServerSideEquation(questionId, control, trigger, variables, equationFunction, isHideIf, useFx) {
    $.ajax({
        type: "POST",
        url: se.baseUrl + "Eval.aspx/Adv",
        data: getEvalData(questionId, equationFunction, variables),
        contentType: "application/json; charset=utf-8",
        dataType: "json",
        async: false,
        headers: seutil.getHeaders()
    })
        .done(function (data) {
            var result = data.d;
            if (isHideIf) result = !result;

            ChangeControlsStates(control, trigger, result, useFx);
        })
        .fail(function (jqXHR, textStatus, errorThrown) {
        });
}

function CreateClientLogic(affectedControls, variables, equationFunction, hide) {
    var logicEvaluator = new LogicEvaluator(equationFunction);

    function ChangeAffectedControlsStates() {
        var result = logicEvaluator.Eval();
        $.each(affectedControls, function (index, value) {
            var control = $("#" + value);
            if (hide) {
                control.toggle(result);
            }
            control.prop('disabled', !result);
            const customCallbackFunction = control.data("custom-callback");
            if (customCallbackFunction && typeof customCallbackFunction === "function") {
                customCallbackFunction();
                control.removeData("custom-callback");
            }
        });
    }

    $.each(variables, function (index, value) {
        getVariableSelector(value).on("change", function () {
            ChangeAffectedControlsStates();
        });
    });

    ChangeAffectedControlsStates();
}

function LogicEvaluator(equationFunction) {
    this.equation = equationFunction;
}

LogicEvaluator.prototype.Eval = function () {
    this.answerCache = [];
    return this.equation(this);
}

LogicEvaluator.prototype.Compares = function (variable, operator, checkAllMentions) {
    var variableAnswer = this.answerCache[variable];
    if (!variableAnswer) {
        variableAnswer = GetRespondentAnswer(variable);
        this.answerCache[variable] = variableAnswer;
    }

    if (variableAnswer && variableAnswer.length > 0) {
        var result = false;

        //Inverse result in the case we want to find one that isn't true
        if (checkAllMentions) {
            result = true;
        }

        for (var i = 0; i < variableAnswer.length; i++) {
            var currentMention = operator(variableAnswer[i]);

            if (checkAllMentions) {
                result = result && currentMention;
            }
            else if (currentMention) {
                return true;
            }
        }

        return result;
    }
    else {
        return operator(null); //Evaluate operators that can return true for an empty answer (DifferentThan, DoesNotContain, Empty...)
    }

    return false;
}

LogicEvaluator.prototype.Equals = function (variable, value) {
    return this.Compares(variable, function (answer) {
        return ((answer == null || answer.length == 0) && value.toString().length == 0) || (answer != null && answer.length > 0 && answer == value);
    });
};
LogicEvaluator.prototype.DifferentThan = function (variable, value) {
    return this.Compares(variable, function (answer) { return answer != value; }, true);
};
LogicEvaluator.prototype.LessThan = function (variable, value) {
    return this.Compares(variable, function (answer) {
        return answer != null && answer.toString().trim().length > 0 && answer < value
    });
};
LogicEvaluator.prototype.MoreThan = function (variable, value) {
    return this.Compares(variable, function (answer) {
        return answer != null && answer.toString().trim().length > 0 && answer > value;
    });
};
LogicEvaluator.prototype.LessThanOrEqual = function (variable, value) {
    return this.Compares(variable, function (answer) {
        return answer != null && answer.toString().trim().length > 0 && answer <= value;
    });
};
LogicEvaluator.prototype.MoreThanOrEqual = function (variable, value) {
    return this.Compares(variable, function (answer) {
        return answer != null && answer.toString().trim().length > 0 && answer >= value;
    });
};
LogicEvaluator.prototype.Contains = function (variable, value) {
    return this.Compares(variable, function (answer) {
        return answer != null && answer.indexOf(value) >= 0;
    });
};
LogicEvaluator.prototype.DoesNotContain = function (variable, value) {
    return this.Compares(variable, function (answer) { return answer == null || answer.indexOf(value) == -1; }, true);
};
LogicEvaluator.prototype.Empty = function (variable, value) {
    return this.Compares(variable, function (answer) { return answer == null || answer.toString().trim().length == 0; }, true);
};
LogicEvaluator.prototype.NotEmpty = function (variable, value) {
    return this.Compares(variable, function (answer) {
        return answer != null && answer.toString().trim().length > 0;
    });
};

function GetRespondentAnswer(variableName) {
    var controls = getVariableSelector(variableName);
    if (controls.length > 0) {
        return $.map(controls, function (val, i) {
            return GetInputValueByQuestionType($(val));
        });
    } else {
        if (se.answers[variableName]) {
            var matrixAnswer = se.answers[variableName][getVariableMatrix(variableName)];

            if (matrixAnswer) {
                return $.map(matrixAnswer.ms, function (mention, i) {
                    return mention.v;
                });
            }
        }
    }
}

function IsVariableSkipped(variableName) {
    var controls = getVariableSelector(variableName);

    return controls.is(".clientSideSkipped") ||
        _.every(controls, (c) => c.closest(".clientSideSkipped")) ||
        controls.is(".serverSideSkipped") ||
        _.every(controls, (c) => c.closest(".serverSideSkipped"));
}

function GetInputValueByQuestionType(input) {
    if (input.hasClass("dragDropValue")) {
        return input.val().split(","); //, function (mention, i) { return mention; });
    }

    if (input.is(":file")) {
        var fileLink = input.closest(".questionContent").find(".fileLink");

        if (fileLink.length > 0)
            return fileLink.text;
        else
            return input.val();
    }

    if (input.is("select")) {
        return $("option:selected", input).val();
    }

    if (!(input.is(":checkbox") || input.is(":radio")) || input.is(":checked")) {
        return input.val();
    }
}

function getVariableMatrix(variableName) {
    var variableMatrix = se.variablesMatrix != null ? se.variablesMatrix[variableName] : null;
    if (!variableMatrix) variableMatrix = se.currentMatrix;
    return variableMatrix;
}

function isCurrentVariableMatrix(variableName, matrix) {
    var variableMatrix = se.variablesMatrix != null ? se.variablesMatrix[variableName] : null;
    if (!variableMatrix) variableMatrix = se.currentMatrix;
    return variableMatrix == matrix;
}

function getEvalData(questionId, equationSyntax, variables) {
    return JSON.stringify({ matrix: se.currentMatrix, questionId: questionId, syntax: equationSyntax, answersData: $("#RespondentAnswers").val(), pageAnswers: getVariableAnswers(variables) });
}

function getVariableAnswers(variables) {
    return $.map(variables, function (variable, i) {
        return {
            vn: variable, ms: GetRespondentAnswer(variable)
        };
    });
}

function isEmptyAnswer(answer) {
    for (var matrix = 0; matrix < answer.length; matrix++) {
        if (typeof answer[matrix] === "string") {
            if (answer[matrix].trim().length > 0) return false;
        } else {
            for (var mention = 0; mention < answer[matrix].length; mention++) {
                if (answer[matrix][mention].toString().trim().length > 0)
                    return false;
            }
        }
    }

    return true;
}

function resetNavigationButtonState() {
    $(".nextButton").prop("disabled", false);
}